#include <iostream>
#include <cmath>
#include <string>
#include <algorithm>
#include <cstring>
#include <cstdio>
#include <fstream>
#include <cassert>
#include <map>
#include <set>
#include <vector>
#include <queue>
#include <stack>
#include <functional>
#include <numeric>
#include <ctime>
#include <cstdlib>
#include <sstream>

using namespace std;

#define f first
#define s second
#define mp make_pair
#define pb push_back
#define pii pair<int, int>
#define pll pair<long long, long long>
#define y1 stupid_y1
#define ll long long
#define vi vector<int>
#define forit(it, s) for(__typeof(s.begin()) it = s.begin(); it != s.end(); it++)
#define all(a) a.begin(), a.end()
#define sqr(x) ((x)*(x))
#define sz(a) (int)a.size()
#define file "a"

const int maxn = (int)2e4+11;
const int inf = int(2e9) + 11;
const int mod = inf + 7;
const double eps = 1e-9;
const double pi = acos(-1.0);

vector < pii > g[maxn];
pair < pii, int > E[maxn];
vector < int > G[maxn];
vector < int > edges;
int timer;
map < pii, int > M;
map < pii, int > ID;
int n, m;
int fup[maxn], tin[maxn];
bool used[maxn];

void dfs(int v, int p){
	used[v] = true;	
	fup[v] = tin[v] = timer++;
	forit(it, G[v]) {
		int to = *it;
		if ( to == p ) continue;
		if ( used[to] )
			fup[v] = min(fup[v], tin[to]);
		else {
			dfs(to, v);
			fup[v] = min(fup[v], fup[to]);
			if ( fup[to] > tin[v] ){
				if ( M[mp(to, v)] == 1 ){
					edges.pb(ID[mp(to,v)]);
				}	
			}
		}
	}
} 	

void shortest(int start, int end, vector < int > &d){
	for (int i=1;i<=n;i++) d[i] = inf;
	priority_queue < pii, vector < pii > , greater < pii > > pq;
	d[start] = 0;
	pq.push(mp(0, start));
	while(!pq.empty() ){
		pii temp = pq.top(); pq.pop();
		int val = temp.f;
		int ind = temp.s;
		if ( val > d[ind] ) continue;
		forit(it, g[ind]){
			pii temp = *it;
			int to = temp.f;
			int cost = temp.s;			
			if ( d[ind] + cost < d[to] ){
				d[to] = d[ind] + cost;
				pq.push(mp(d[to], to));
			}
		}
	}
}

void show(vector < int > ans){
	printf("%d\n", sz(ans));
	forit(it, ans){
		printf("%d ", *it);
	}
}

int main () {

	#ifdef LOCAL
	freopen(file".in", "r", stdin);
	freopen(file".out", "w", stdout);
	#endif

	scanf("%d%d", &n, &m);

	for (int i=0;i<m;i++){
		int a, b, c;
		scanf("%d%d%d", &a, &b, &c);
		g[a].pb(mp(b,c));
		g[b].pb(mp(a,c));
		E[i] = mp(mp(a, b), c);
	}

	vector < int > d1(n+1, 0);
	shortest(1, n, d1);

	vector < int > d2(n+1, 0);
	shortest(n, 1, d2); 

	vector < int > ans;
	if ( d1[n] == inf ){
		show(ans);
		return 0;
	} 

	for (int i=1;i<=n;i++) g[i].clear();


	for (int i=0;i<m;i++){
		int a = E[i].f.f;
		int b = E[i].f.s;
		int c = E[i].s;
		if ( d1[a] + c + d2[b] == d1[n] ){
			G[a].pb(b);
			G[b].pb(a);
			M[mp(a,b)]++;
			M[mp(b,a)]++;
			ID[mp(a,b)] = i + 1;
			ID[mp(b,a)] = i + 1;
			continue;
		}
		swap(a, b);
		if ( d1[a] + c + d2[b] == d1[n] ){
			G[a].pb(b);
			G[b].pb(a);
			M[mp(a,b)]++;
			M[mp(b,a)]++;
			ID[mp(a,b)] = i + 1;
			ID[mp(b,a)] = i + 1;
		}
	}

	dfs(1, -1);

	show(edges);





	#ifdef LOCAL
	cerr << (double)clock() * 1.0 / CLOCKS_PER_SEC << endl;
	#endif

	return 0;
}
